#!/bin/bash
# Test: Check Notifications
# Expectation: Script runs without error and outputs valid JSON with "success":true

OUTPUT=$(bash skills/auto/check_notifications.sh)
EXIT_CODE=$?

if [ $EXIT_CODE -ne 0 ]; then
    echo "❌ Script exited with error code $EXIT_CODE"
    exit 1
fi

# Check if output contains "success":true
if echo "$OUTPUT" | grep -q '"success":true'; then
    echo "✅ Output contains success:true"
    exit 0
else
    echo "❌ Output invalid: $OUTPUT"
    exit 1
fi
