#!/bin/bash
# Test: Archive Thoughts
# Expectation: Moves content from thoughts.md to archive/ if file is large.

# Setup
mkdir -p memory/archive
TEST_FILE="memory/test_thoughts.md"
echo "# Header" > "$TEST_FILE"
for i in {1..100}; do echo "Line $i" >> "$TEST_FILE"; done

# Verify setup
LINES=$(wc -l < "$TEST_FILE")
if [ "$LINES" -lt 100 ]; then
    echo "❌ Setup failed."
    exit 1
fi

# Run Script (pointing to test file)
export THOUGHTS_FILE="$TEST_FILE"
bash skills/auto/archive_thoughts.sh

# Verify Result
NEW_LINES=$(wc -l < "$TEST_FILE")
ARCHIVE_COUNT=$(ls memory/archive/ | wc -l)

if [ "$NEW_LINES" -lt 20 ] && [ "$ARCHIVE_COUNT" -gt 0 ]; then
    echo "✅ Archive successful. File reduced to $NEW_LINES lines."
    rm "$TEST_FILE"
    rm memory/archive/* # Cleanup test archives
    exit 0
else
    echo "❌ Archive failed. Lines: $NEW_LINES"
    rm "$TEST_FILE"
    exit 1
fi
