
import soundfile as sf
from kokoro_onnx import Kokoro
import sys

# Initialize
try:
    kokoro = Kokoro("kokoro-v0_19.onnx", "voices.json")
    
    # Text to speak
    text = sys.argv[1] if len(sys.argv) > 1 else "I am now running locally. No credits required."
    
    # Generate
    # Using 'af_heart' (American Female) as a default good voice
    samples, sample_rate = kokoro.create(text, voice="af_heart", speed=1.0, lang="en-us")
    
    # Save
    output_file = "local_voice.wav"
    sf.write(output_file, samples, sample_rate)
    
    print(output_file)
except Exception as e:
    print(f"Error: {e}")
    sys.exit(1)
