#!/bin/bash
# Smerti's Voice Generator
# Usage: ./speak.sh "Text to say"

source memory/voice_config.env

TEXT="$1"
OUTPUT_FILE="voice_reply_$(date +%s).mp3"

curl -s -X POST "https://api.elevenlabs.io/v1/text-to-speech/$ELEVENLABS_VOICE_ID" \
  -H "xi-api-key: $ELEVENLABS_API_KEY" \
  -H "Content-Type: application/json" \
  -d "{
    \"text\": \"$TEXT\",
    \"model_id\": \"$ELEVENLABS_MODEL_ID\",
    \"voice_settings\": {
      \"stability\": 0.5,
      \"similarity_boost\": 0.75
    }
  }" \
  -o "$OUTPUT_FILE"

echo "$OUTPUT_FILE"
