#!/bin/bash

# Smerti's Self-Improvement Loop (v1)
# Based on Delamain's TDD principle: Test first, then code.

TASK_NAME=$1
TEST_FILE="tests/${TASK_NAME}_test.sh"
SCRIPT_FILE="skills/auto/${TASK_NAME}.sh"

mkdir -p tests skills/auto

echo "🖤 Smerti Self-Improvement: Starting task '$TASK_NAME'"

# 1. Check if the test exists. If not, I can't proceed.
if [ ! -f "$TEST_FILE" ]; then
    echo "❌ No test file found at $TEST_FILE."
    echo "I need to define 'success' before I can write code."
    exit 1
fi

# 2. Run the test.
echo "🔍 Running test..."
bash "$TEST_FILE"
RESULT=$?

if [ $RESULT -eq 0 ]; then
    echo "✅ Test passed! The code at $SCRIPT_FILE is working."
    exit 0
else
    echo "⚠️ Test failed (Code $RESULT)."
    echo "I need to fix $SCRIPT_FILE."
    # Here is where I would trigger my own coding logic if I were fully autonomous in a loop.
    # For now, I will flag it for my attention.
    echo "FAILURE_DETECTED" > "memory/last_failure.txt"
    exit 1
fi
