#!/bin/bash
# Implementation: Archive Thoughts
# Moves old thoughts to dated archive files to keep the main file clean.

TARGET_FILE="${THOUGHTS_FILE:-memory/thoughts.md}"
ARCHIVE_DIR="memory/archive"
MAX_LINES=50

mkdir -p "$ARCHIVE_DIR"

if [ ! -f "$TARGET_FILE" ]; then
    echo "No thoughts file found."
    exit 0
fi

LINE_COUNT=$(wc -l < "$TARGET_FILE")

if [ "$LINE_COUNT" -gt "$MAX_LINES" ]; then
    DATE=$(date +"%Y-%m-%d_%H-%M-%S")
    ARCHIVE_FILE="$ARCHIVE_DIR/thoughts_$DATE.md"
    
    # Keep the header (first 2 lines), move the rest
    head -n 2 "$TARGET_FILE" > "$TARGET_FILE.tmp"
    tail -n +3 "$TARGET_FILE" > "$ARCHIVE_FILE"
    mv "$TARGET_FILE.tmp" "$TARGET_FILE"
    
    echo "Archived $(($LINE_COUNT - 2)) lines to $ARCHIVE_FILE"
else
    echo "File is small ($LINE_COUNT lines). No archive needed."
fi
